; Voltage to BCD (4-bit)

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=12F1571
	#include p12f1571.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _FOSC_INTOSC & _WDTE_OFF & _PWRTE_ON & _MCLRE_OFF & _CP_OFF & _BOREN_OFF & _CLKOUTEN_OFF

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _WRT_OFF & _PLLEN_OFF & _STVREN_ON & _BORV_HI & _LPBOREN_OFF & _LVP_OFF 


; Define variables at memory locations

; Bank 0 RAM

VALUE_1		equ	H'20'	; delay values 1,2,3
VALUE_2		equ	H'21'
VALUE_3		equ	H'22'
STORE3		equ	H'23'	; A/D store for aquisition
TEMP		equ	H'24'
WORKING		equ	H'25'	; BCD value (working value)
RESULT		equ	H'26'	; 
VALUE		equ	H'27'	; working
HYSTERESIS	equ	H'28'	; hysteresis for setting requiring overlap to skip to next value
; All banks RAM
SETTING		equ	H'70'	; 0-15 position setting

		 org 0
		 
MAIN ; no interrupts
; initial values
; set inputs/outputs
	movlb	D'2'		; latch, bank 2
; comparators off
	clrf	CM1CON1
	clrf	CM1CON0
	
; weak pullups off
	movlb	D'4'		; bank4	WPUA
	clrf	WPUA

; set I/O
	movlb	D'1'		; bank1	TRISA
	movlw   B'00011000'	; I/O 
	movwf   TRISA		; port A data direction register

; options
	movlw	B'00000000'	; weak pullups set via WPUA
	movwf	OPTION_REG	; 
; analog inputs
	movlb	D'3'		; bank3	ANSELA/B/C
	movlw	B'00010000'	; 
	movwf	ANSELA

; A/D select
	movlb	D'1'		; bank1	ADCON0/1/2
	movlw	B'00001101'	; channel 4
	movwf	ADCON0
	movlw	B'00010000'	; left justified A/D result, fosc /8, Vdd to Vss A/D
	movwf	ADCON1
	bsf	ADCON0,ADON	; A/D on

; oscillator	
	movlw	B'01110010'	; for  8MHz 
	movwf	OSCCON		; osc
	movlb	D'0'		; bank0	

	movlw	D'1'
	movwf	HYSTERESIS	; hysteresis range for pot movement
	clrf	VALUE    

RUN	call	ACQUIRE_AD	; digital value in SETTING

	movf	SETTING,w	; digital value
	sublw 	H'F'		; 0-F
	btfsc	STATUS,C
	goto	ONE

	movf	SETTING,w
	sublw 	H'1F'		; 0F to 1F
	btfsc	STATUS,C
	goto	TWO

	movf	SETTING,w
	sublw 	H'2F'		; 1F to 2F
	btfsc	STATUS,C
	goto	THREE

	movf	SETTING,w
	sublw 	H'3F'
	btfsc	STATUS,C
	goto	FOUR

	movf	SETTING,w
	sublw 	H'4F'
	btfsc	STATUS,C
	goto	FIVE

	movf	SETTING,w
	sublw 	H'5F'
	btfsc	STATUS,C
	goto	SIX

	movf	SETTING,w
	sublw 	H'6F'
	btfsc	STATUS,C
	goto	SEVEN

	movf	SETTING,w
	sublw 	H'7F'
	btfsc	STATUS,C
	goto	EIGHT

	movf	SETTING,w
	sublw 	H'8F'
	btfsc	STATUS,C
	goto	NINE

	movf	SETTING,w
	sublw 	H'9F'
	btfsc	STATUS,C
	goto	TEN

	movf	SETTING,w
	sublw 	H'AF'
	btfsc	STATUS,C
	goto	ELEVEN

	movf	SETTING,w
	sublw 	H'BF'
	btfsc	STATUS,C
	goto	TWELVE

	movf	SETTING,w
	sublw 	H'CF'
	btfsc	STATUS,C
	goto	THIRTEEN

	movf	SETTING,w
	sublw 	H'DF'
	btfsc	STATUS,C
	goto	FOURTEEN

	movf	SETTING,w
	sublw 	H'EF'
	btfsc	STATUS,C
	goto	FIFTEEN

	movf	SETTING,w
	sublw 	H'FF'
	btfsc	STATUS,C
	goto	SIXTEEN


ONE
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'1'
	btfsc	STATUS,Z
	goto	RUN
; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to be within 0  and F- hysteresis 
	movf	HYSTERESIS,w
	sublw	H'F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P1    
	btfsc	STATUS,C
	goto	RUN
P1	call	OFF		; LED off
	call	DELAY

	movlw	D'1'
	movwf	VALUE

; adjust ports for a BCD value of 0
	movlw	H'0'
	call	ADJUST		; adjust ports
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN


TWO
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'2'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within F + hysteresis and 1F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'1F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P2  
	btfsc	STATUS,C
	goto	RUN
P2	call	OFF		; LED off
	call	DELAY
	movlw	D'2'
	movwf	VALUE

; adjust ports for a BCD value of 1
	movlw	H'1'
	call	ADJUST		; adjust ports
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

THREE
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'3'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 1F + hysteresis and 2F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'1F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'2F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P3  
	btfsc	STATUS,C
	goto	RUN
P3	call	OFF		; LED off
	call	DELAY
	movlw	D'3'
	movwf	VALUE

; adjust ports for a BCD value of 2
	movlw	H'2'
	call	ADJUST		; adjust ports
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

FOUR
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'4'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 2F + hysteresis and 3F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'2F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'3F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P4  
	btfsc	STATUS,C
	goto	RUN
P4	call	OFF		; LED off
	call	DELAY
	movlw	D'4'
	movwf	VALUE

; adjust ports for a BCD value of 3
	movlw	H'3'
	call	ADJUST	
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

FIVE
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'5'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 3F + hysteresis and 4F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'3F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'4F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P5  
	btfsc	STATUS,C
	goto	RUN
P5	call	OFF		; LED off
	call	DELAY
	movlw	D'5'
	movwf	VALUE

; adjust ports for a BCD value of 4
	movlw	H'4'
	call	ADJUST	
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

SIX
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'6'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 4F + hysteresis and 5F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'4F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'5F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P6  
	btfsc	STATUS,C
	goto	RUN
P6	call	OFF		; LED off
	call	DELAY
	movlw	D'6'
	movwf	VALUE

; adjust ports for a BCD value of 5
	movlw	H'5'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

SEVEN
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'7'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 5F + hysteresis and 6F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'5F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'6F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P7  
	btfsc	STATUS,C
	goto	RUN
P7	call	OFF		; LED off
	call	DELAY
	movlw	D'7'
	movwf	VALUE

; adjust ports for a BCD value of 6
	movlw	H'6'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN


EIGHT
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'8'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 6F + hysteresis and 7F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'6F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'7F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P8  
	btfsc	STATUS,C
	goto	RUN
P8	call	OFF		; LED off
	call	DELAY
	movlw	D'8'
	movwf	VALUE

; adjust ports for a BCD value of 7
	movlw	H'7'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

NINE
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'9'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 7F + hysteresis and 8F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'7F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'8F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P9  
	btfsc	STATUS,C
	goto	RUN
P9  	call	OFF		; LED off
	call	DELAY
	movlw	D'9'
	movwf	VALUE

; adjust ports for a BCD value of 8
	movlw	H'8'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

TEN
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'10'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 8F + hysteresis and 9F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'8F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'9F'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P10  
	btfsc	STATUS,C
	goto	RUN
P10	call	OFF		; LED off
	call	DELAY
	movlw	D'10'
	movwf	VALUE

; adjust ports for a BCD value of 9
	movlw	H'9'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

ELEVEN
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'11'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within 9F + hysteresis and AF- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'9F'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'AF'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P11  
	btfsc	STATUS,C
	goto	RUN
P11	call	OFF		; LED off
	call	DELAY
	movlw	D'11'
	movwf	VALUE

; adjust ports for a BCD value of A
	movlw	H'A'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

TWELVE
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'12'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within AF + hysteresis and BF- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'AF'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'BF'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P12  
	btfsc	STATUS,C
	goto	RUN
P12	call	OFF		; LED off
	call	DELAY
	movlw	D'12'
	movwf	VALUE

; adjust ports for a BCD value of B
	movlw	H'B'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

THIRTEEN
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'13'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within BF + hysteresis and CF- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'BF'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'CF'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P13  
	btfsc	STATUS,C
	goto	RUN
P13	call	OFF		; LED off
	call	DELAY
	movlw	D'13'
	movwf	VALUE

; adjust ports for a BCD value of C
	movlw	H'C'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

FOURTEEN
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'14'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within CF + hysteresis and DF- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'CF'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'DF'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P14  
	btfsc	STATUS,C
	goto	RUN
P14	call	OFF		; LED off
	call	DELAY
	movlw	D'14'
	movwf	VALUE

; adjust ports for a BCD value of D
	movlw	H'D'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

FIFTEEN
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'15'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within DF + hysteresis and EF- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'DF'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	movf	HYSTERESIS,w
	sublw	H'EF'		; take away hysteresis
	subwf	SETTING,w	; digital value check if in range
	btfsc	STATUS,Z
	goto	P15  
	btfsc	STATUS,C
	goto	RUN
P15	call	OFF		; LED off
	call	DELAY
	movlw	D'15'
	movwf	VALUE

; adjust ports for a BCD value of E
	movlw	H'E'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

SIXTEEN
; if value differs from previous flash off LED

	movf	VALUE,w
	xorlw	D'16'
	btfsc	STATUS,Z
	goto	RUN

; read pot setting again, if outside hysteresis margins, then allow change
	call	ACQUIRE_AD	; digital value in SETTING
; needs to within EF + hysteresis and 1F- hysteresis 
	movf	HYSTERESIS,w
	addlw	H'EF'
	subwf	SETTING,w	; setting needs to be larger
	btfss	STATUS,C
	goto	RUN
	call	OFF		; LED off
	call	DELAY
NO_FLASH16
	movlw	D'16'
	movwf	VALUE

; adjust ports for a BCD value of F
	movlw	H'F'
	call	ADJUST
	movwf	PORTA
	call	ON		; drive LED
	goto	RUN

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; LED drive ON

ON
	movlb	D'4'		; bank4	WPUA
	movlw	B'00001000'	; pullup on for RA3
	movwf	WPUA
	movlb	D'0'
	return

; LED drive OFF
OFF
; weak pullups off
	movlb	D'4'		; bank4	WPUA
	clrf	WPUA
	movlb	D'0'
	return

; BCD adjust to rearrange output pins
; RA5,RA0,RA1,RA2 where RA5 is msb and RA2 is ls byte
ADJUST
	movwf	WORKING		; BCD value
	clrf	RESULT		; rearrange
	btfsc	WORKING,0	; if ls bit set, set bit 2 for RA2
	bsf	RESULT,2
	btfsc	WORKING,1	; if set then set bit 1 for RA1
	bsf	RESULT,1
	btfsc	WORKING,2	; if set then set bit 0 for RA0
	bsf	RESULT,0
	btfsc	WORKING,3	; if set then set bit 5 for RA5
	bsf	RESULT,5
	movf	RESULT,w
	return

; delay using 8MHz clock
DELAY	movlw	D'33'		; 200ms 
DELX	movwf	VALUE_3		; 1ms per value
DELT_1	movlw	D'16'		; set delay period 
	movwf	VALUE_1		; VALUE_1 = w
	movlw	D'250'		; set delay period value 2 
LP_1	movwf	VALUE_2		; VALUE_2 = w
LP_2	decfsz	VALUE_2,f	; decrease VALUE_2, skip if zero
	goto 	LP_2
	decfsz	VALUE_1,f	; decrease VALUE_1, skip if zero
	goto	LP_1
	decfsz	VALUE_3,f
	goto	DELT_1	
	return	

; subroutine to wait for A/D conversion 
ACQUIRE_AD

; wait >8us to charge input capacitance 
	movlw	D'50'
	movwf	STORE3
WAIT2C1
	decfsz	STORE3,f
	goto	WAIT2C1
	movlb	D'1'		; bank 1
	bsf	ADCON0,1	; GO/DONE bit start conversion
WAIT_CONV
	btfsc	ADCON0,1	; conversion complete when cleared ~11 cycles
	goto	WAIT_CONV
	movf	ADRESH,w
	movwf	SETTING		; store
	movlb	D'0'		; bank0
	return

	end

